/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.networking;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.impactdev.impactor.api.economy.transactions.EconomyTransaction;
import net.impactdev.impactor.api.economy.transactions.EconomyTransferTransaction;
import net.impactdev.impactor.api.economy.transactions.details.EconomyTransactionType;
import net.impactdev.impactor.api.logging.PluginLogger;
import net.impactdev.impactor.core.economy.accounts.AccountManager;
import net.impactdev.impactor.core.economy.accounts.ImpactorAccount;
import net.impactdev.impactor.core.economy.networking.consumption.MessageConsumer;
import net.impactdev.impactor.core.economy.networking.messages.Message;
import net.impactdev.impactor.core.economy.networking.messages.TransactionMessage;
import net.impactdev.impactor.core.economy.networking.messages.TransferTransactionMessage;
import net.impactdev.impactor.core.economy.networking.messenger.Messenger;
import net.impactdev.impactor.core.economy.transactions.context.TransactionContext;
import net.impactdev.impactor.core.economy.transactions.context.TransferTransactionContext;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.impactdev.impactor.core.utility.collections.ExpiringSet;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.NotNull;

public final class EconomyNetworkingService
implements MessageConsumer {
    private final AccountManager manager;
    private final PluginLogger logger;
    private final Messenger messenger;
    private final ExpiringSet<UUID> received = new ExpiringSet(5L, TimeUnit.MINUTES);

    public EconomyNetworkingService(BaseImpactorPlugin plugin, AccountManager manager, Messenger.Provider provider) {
        this.logger = plugin.logger();
        this.manager = manager;
        this.messenger = provider.obtain(this);
    }

    public CompletableFuture<Void> publishTransaction(EconomyTransaction transaction) {
        return CompletableFuture.runAsync(() -> {
            UUID id = this.generateID();
            this.logger.debug("Publishing transaction with ID: " + String.valueOf(id));
            this.messenger.publish(new TransactionMessage(id, transaction));
        });
    }

    public CompletableFuture<Void> publishTransaction(EconomyTransferTransaction transaction) {
        return CompletableFuture.runAsync(() -> {
            UUID id = this.generateID();
            this.logger.debug("Publishing transaction with ID: " + String.valueOf(id));
            this.messenger.publish(new TransferTransactionMessage(id, transaction));
        });
    }

    private UUID generateID() {
        UUID uuid = UUID.randomUUID();
        this.received.add(uuid);
        return uuid;
    }

    @Override
    public void consume(@NotNull Message message) {
        Objects.requireNonNull(message, "message cannot be null");
        if (!this.received.add(message.id())) {
            return;
        }
        this.processIncomingMessage(message);
    }

    @Override
    public void consume(@NotNull JsonElement json) {
        Objects.requireNonNull(json, "json cannot be null");
        JsonObject root = json.getAsJsonObject();
        JsonElement id = root.get("id");
        if (id == null) {
            throw new IllegalStateException("Incoming message has no ID argument: " + String.valueOf(root));
        }
        UUID uuid = UUID.fromString(id.getAsString());
        if (!this.received.add(uuid)) {
            return;
        }
        JsonElement type = root.get("key");
        if (type == null) {
            throw new IllegalStateException("Incoming message has no key argument: " + String.valueOf(root));
        }
        Key key = Key.key((String)type.getAsString());
        JsonElement content = root.get("content");
        Message message = this.deserialize(uuid, key, content);
        this.processIncomingMessage(message);
    }

    private Message deserialize(UUID id, Key key, JsonElement content) {
        if (key == TransactionMessage.KEY) {
            return TransactionMessage.deserialize(id, content);
        }
        return TransferTransactionMessage.deserialize(id, content);
    }

    private void processIncomingMessage(@NotNull Message message) {
        if (message instanceof TransactionMessage) {
            TransactionMessage transaction = (TransactionMessage)message;
            TransactionContext context = transaction.context();
            this.manager.accountIfPresent(context.account(), context.currency()).map(x -> (ImpactorAccount)x).ifPresent(x -> this.manager.update((ImpactorAccount)x, context.amount(), context.type()));
        } else if (message instanceof TransferTransactionMessage) {
            TransferTransactionMessage transaction = (TransferTransactionMessage)message;
            TransferTransactionContext context = transaction.context();
            this.manager.accountIfPresent(context.from(), context.currency()).map(x -> (ImpactorAccount)x).ifPresent(x -> this.manager.update((ImpactorAccount)x, context.amount(), EconomyTransactionType.WITHDRAW));
            this.manager.accountIfPresent(context.to(), context.currency()).map(x -> (ImpactorAccount)x).ifPresent(x -> this.manager.update((ImpactorAccount)x, context.amount(), EconomyTransactionType.DEPOSIT));
        }
    }
}

